/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.AtomicsBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.helper.SharedMemorySync;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class AtomicsBuiltins
extends JSBuiltinsContainer.SwitchEnum<Atomics> {
    public static final JSBuiltinsContainer BUILTINS = new AtomicsBuiltins();
    public static final JSBuiltinsContainer WAIT_ASYNC_BUILTIN = new AtomicsWaitAsyncBuiltin();
    public static final String OK = "ok";
    public static final String NOT_EQUAL = "not-equal";
    public static final String TIMED_OUT = "timed-out";

    protected AtomicsBuiltins() {
        super("Atomics", Atomics.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Atomics builtinEnum) {
        assert (context.getEcmaScriptVersion() >= 8);
        switch (builtinEnum) {
            case compareExchange: {
                return AtomicsBuiltinsFactory.AtomicsCompareExchangeNodeGen.create(context, builtin, AtomicsBuiltins.args().fixedArgs(4).createArgumentNodes(context));
            }
            case load: {
                return AtomicsBuiltinsFactory.AtomicsLoadNodeGen.create(context, builtin, AtomicsBuiltins.args().fixedArgs(4).createArgumentNodes(context));
            }
            case store: {
                return AtomicsBuiltinsFactory.AtomicsStoreNodeGen.create(context, builtin, AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case add: {
                return AtomicsBuiltinsFactory.AtomicsComputeNodeGen.create(context, builtin, (a, b) -> a + b, (a, b) -> a.add((BigInt)b), AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case sub: {
                return AtomicsBuiltinsFactory.AtomicsComputeNodeGen.create(context, builtin, (a, b) -> a - b, (a, b) -> a.subtract((BigInt)b), AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case and: {
                return AtomicsBuiltinsFactory.AtomicsComputeNodeGen.create(context, builtin, (a, b) -> a & b, (a, b) -> a.and((BigInt)b), AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case or: {
                return AtomicsBuiltinsFactory.AtomicsComputeNodeGen.create(context, builtin, (a, b) -> a | b, (a, b) -> a.or((BigInt)b), AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case xor: {
                return AtomicsBuiltinsFactory.AtomicsComputeNodeGen.create(context, builtin, (a, b) -> a ^ b, (a, b) -> a.xor((BigInt)b), AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case exchange: {
                return AtomicsBuiltinsFactory.AtomicsComputeNodeGen.create(context, builtin, (a, b) -> b, (a, b) -> b, AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case wake: 
            case notify: {
                return AtomicsBuiltinsFactory.AtomicsNotifyNodeGen.create(context, builtin, AtomicsBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case wait: {
                return AtomicsBuiltinsFactory.AtomicsWaitNodeGen.create(context, builtin, AtomicsBuiltins.args().fixedArgs(4).createArgumentNodes(context));
            }
            case isLockFree: {
                return AtomicsBuiltinsFactory.AtomicsIsLockFreeNodeGen.create(context, builtin, AtomicsBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface AtomicBinaryOperator<T> {
        public T apply(T var1, T var2);
    }

    @FunctionalInterface
    public static interface AtomicIntBinaryOperator {
        public int applyAsInt(int var1, int var2);
    }

    public static abstract class AtomicsIsLockFreeNode
    extends AtomicsOperationNode {
        private static final boolean AR_IsLockFree1 = true;
        private static final boolean AR_IsLockFree2 = true;

        public AtomicsIsLockFreeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doGeneric(Object size, @Cached(value="create()") JSToInt32Node toInt32Node) {
            int n = toInt32Node.executeInt(size);
            if (n == 1) {
                return true;
            }
            if (n == 2) {
                return true;
            }
            if (n == 4) {
                return true;
            }
            if (n == 8) {
                return !this.getContext().getContextOptions().isTestV8Mode();
            }
            return false;
        }
    }

    public static abstract class AtomicsWaitAsyncNode
    extends AtomicsWaitBaseNode {
        public AtomicsWaitAsyncNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doGeneric(VirtualFrame frame, Object maybeTarget, Object index, Object value, Object timeout) {
            return this.doWait(frame, maybeTarget, index, value, timeout, true);
        }
    }

    public static abstract class AtomicsWaitNode
    extends AtomicsWaitBaseNode {
        public AtomicsWaitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doGeneric(VirtualFrame frame, Object maybeTarget, Object index, Object value, Object timeout) {
            return this.doWait(frame, maybeTarget, index, value, timeout, false);
        }
    }

    public static abstract class AtomicsWaitBaseNode
    extends AtomicsOperationNode {
        private final ConditionProfile isAsyncProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile timeoutNaNProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile valuesNotEqualBranch = BranchProfile.create();
        private final BranchProfile asyncImmediateTimeoutBranch = BranchProfile.create();
        private final ConditionProfile awokenProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile errorBranch = BranchProfile.create();
        @Node.Child
        private JSToIndexNode toIndexNode = JSToIndexNode.create();
        @Node.Child
        private JSToDoubleNode toDoubleNode = JSToDoubleNode.create();
        @Node.Child
        private AtomicsLoadNode loadNode = this.createHelperNode();
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        @Node.Child
        private JSToInt32Node toInt32Node;
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private CreateObjectNode objectCreateNode;
        @Node.Child
        private CreateDataPropertyNode createAsyncPropertyNode;
        @Node.Child
        private CreateDataPropertyNode createValuePropertyNode;

        public AtomicsWaitBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createAsyncPropertyNode = CreateDataPropertyNode.create(context, "async");
            this.createValuePropertyNode = CreateDataPropertyNode.create(context, "value");
        }

        protected AtomicsLoadNode createHelperNode() {
            return AtomicsBuiltinsFactory.AtomicsLoadNodeGen.create(this.getContext(), this.getBuiltin(), JSBuiltinsContainer.args().fixedArgs(4).createArgumentNodes(this.getContext()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWait(VirtualFrame frame, Object maybeTarget, Object index, Object value, Object timeout, boolean isAsync) {
            DynamicObject target = this.ensureDynamicObject(maybeTarget);
            this.validateSharedIntegerTypedArray(target, true);
            int i = AtomicsWaitBaseNode.validateAtomicAccess(target, this.toIndexNode.executeLong(index), index);
            boolean isInt32 = AtomicsWaitBaseNode.isInt32SharedBufferView(maybeTarget);
            long v = isInt32 ? (long)this.toInt32(value) : this.toBigInt(value).longValue();
            double q = this.toDoubleNode.executeDouble(timeout);
            double t = this.timeoutNaNProfile.profile(JSRuntime.isNaN(q)) ? Double.POSITIVE_INFINITY : Math.max(q, 0.0);
            if (!isAsync && !SharedMemorySync.agentCanSuspend(this.getContext())) {
                this.errorBranch.enter();
                throw this.createTypeErrorUnsupported();
            }
            JSAgentWaiterList.JSAgentWaiterListEntry wl = SharedMemorySync.getWaiterList(this.getContext(), target, i);
            PromiseCapabilityRecord promiseCapability = null;
            DynamicObject resultObject = null;
            if (this.isAsyncProfile.profile(isAsync)) {
                this.getContext().signalAsyncWaiterRecordUsage();
                promiseCapability = this.newPromiseCapability();
                resultObject = this.ordinaryObjectCreate(frame);
            }
            SharedMemorySync.enterCriticalSection(this.getContext(), wl);
            try {
                boolean isNotEqual;
                Object w = this.loadNode.executeWithBufferAndIndex(frame, maybeTarget, i);
                boolean bl = isInt32 ? !(w instanceof Integer) || (Integer)w != (int)v : (isNotEqual = !(w instanceof BigInt) || ((BigInt)w).longValue() != v);
                if (isNotEqual) {
                    this.valuesNotEqualBranch.enter();
                    if (!this.isAsyncProfile.profile(isAsync)) {
                        String string = AtomicsBuiltins.NOT_EQUAL;
                        return string;
                    }
                    this.createAsyncPropertyNode.executeVoid(resultObject, false);
                    this.createValuePropertyNode.executeVoid(resultObject, AtomicsBuiltins.NOT_EQUAL);
                    DynamicObject dynamicObject = resultObject;
                    return dynamicObject;
                }
                if (isAsync && t == 0.0) {
                    this.asyncImmediateTimeoutBranch.enter();
                    this.createAsyncPropertyNode.executeVoid(resultObject, false);
                    this.createValuePropertyNode.executeVoid(resultObject, AtomicsBuiltins.TIMED_OUT);
                    DynamicObject dynamicObject = resultObject;
                    return dynamicObject;
                }
                JSAgent agent = this.getContext().getJSAgent();
                int id = agent.getSignifier();
                JSAgentWaiterList.WaiterRecord waiterRecord = JSAgentWaiterList.WaiterRecord.create(id, promiseCapability, t, AtomicsBuiltins.OK, wl, agent);
                SharedMemorySync.addWaiter(this.getContext(), wl, waiterRecord, isAsync);
                if (!this.isAsyncProfile.profile(isAsync)) {
                    boolean awoken = SharedMemorySync.suspendAgent(this.getContext(), wl, waiterRecord);
                    if (this.awokenProfile.profile(awoken)) {
                        assert (!wl.contains(waiterRecord));
                        String string = AtomicsBuiltins.OK;
                        return string;
                    }
                    SharedMemorySync.removeWaiter(this.getContext(), wl, waiterRecord);
                    String string = AtomicsBuiltins.TIMED_OUT;
                    return string;
                }
                this.createAsyncPropertyNode.executeVoid(resultObject, true);
                this.createValuePropertyNode.executeVoid(resultObject, waiterRecord.getPromiseCapability().getPromise());
                DynamicObject dynamicObject = resultObject;
                return dynamicObject;
            }
            finally {
                SharedMemorySync.leaveCriticalSection(this.getContext(), wl);
            }
        }

        private int toInt32(Object v) {
            if (this.toInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toInt32Node = (JSToInt32Node)this.insert(JSToInt32Node.create());
            }
            return this.toInt32Node.executeInt(v);
        }

        private BigInt toBigInt(Object v) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = (JSToBigIntNode)this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.executeBigInteger(v);
        }

        private PromiseCapabilityRecord newPromiseCapability() {
            if (this.newPromiseCapabilityNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.newPromiseCapabilityNode = (NewPromiseCapabilityNode)this.insert(NewPromiseCapabilityNode.create(this.getContext()));
            }
            return this.newPromiseCapabilityNode.executeDefault();
        }

        private DynamicObject ordinaryObjectCreate(VirtualFrame frame) {
            if (this.objectCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectCreateNode = (CreateObjectNode)this.insert(CreateObjectNode.create(this.getContext()));
            }
            return this.objectCreateNode.execute(frame);
        }
    }

    public static abstract class AtomicsNotifyNode
    extends AtomicsOperationNode {
        public AtomicsNotifyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doGeneric(Object maybeTarget, Object index, Object count, @Cached(value="create()") JSToIndexNode toIndexNode, @Cached(value="create()") JSToInt32Node toInt32Node) {
            DynamicObject target = this.ensureDynamicObject(maybeTarget);
            this.validateSharedIntegerTypedArray(target, true);
            int i = AtomicsNotifyNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            int c = Integer.MAX_VALUE;
            if (count != Undefined.instance) {
                int tmp = toInt32Node.executeInt(count);
                c = Integer.max(tmp, 0);
            }
            JSAgentWaiterList.JSAgentWaiterListEntry wl = SharedMemorySync.getWaiterList(this.getContext(), target, i);
            SharedMemorySync.enterCriticalSection(this.getContext(), wl);
            try {
                int n;
                JSAgentWaiterList.WaiterRecord[] waiters = SharedMemorySync.removeWaiters(this.getContext(), wl, c);
                for (n = 0; n < waiters.length; ++n) {
                    if (waiters[n].getPromiseCapability() == null) {
                        SharedMemorySync.notifyWaiter(this.getContext(), waiters[n]);
                        continue;
                    }
                    waiters[n].setNotified();
                    if (!Double.isInfinite(waiters[n].getTimeout())) continue;
                    waiters[n].enqueueInAgent();
                }
                Integer n2 = n;
                return n2;
            }
            finally {
                SharedMemorySync.leaveCriticalSection(this.getContext(), wl);
            }
        }
    }

    public static abstract class AtomicsComputeNode
    extends AtomicsOperationNode {
        private final AtomicIntBinaryOperator intOperator;
        private final AtomicBinaryOperator<BigInt> bigIntOperator;
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        @Node.Child
        private JSToIntegerAsLongNode toIntNode;

        public AtomicsComputeNode(JSContext context, JSBuiltin builtin, AtomicIntBinaryOperator intOperator, AtomicBinaryOperator<BigInt> bigIntOperator) {
            super(context, builtin);
            this.intOperator = intOperator;
            this.bigIntOperator = bigIntOperator;
        }

        private int atomicDoInt(DynamicObject target, int index, int value) {
            int result;
            int initial;
            do {
                initial = SharedMemorySync.doVolatileGet(target, index);
                result = this.intOperator.applyAsInt(initial, value);
            } while (!SharedMemorySync.compareAndSwapInt(this.getContext(), target, index, initial, result));
            return initial;
        }

        private BigInt atomicDoBigInt(DynamicObject target, int index, BigInt value) {
            BigInt result;
            BigInt initial;
            do {
                initial = SharedMemorySync.doVolatileGetBigInt(target, index);
                result = this.bigIntOperator.apply(initial, value);
            } while (!SharedMemorySync.compareAndSwapBigInt(this.getContext(), target, index, initial, result));
            return initial;
        }

        @Specialization(guards={"isInt8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt8ArrayObj(DynamicObject target, int index, int value) {
            return (byte)this.atomicDoInt(target, index, value);
        }

        @Specialization(guards={"isUint8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doUint8ArrayObj(DynamicObject target, int index, int value) {
            return (byte)this.atomicDoInt(target, index, value) & 0xFF;
        }

        @Specialization(guards={"isInt16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt16ArrayObj(DynamicObject target, int index, int value) {
            return this.atomicDoInt(target, index, value);
        }

        @Specialization(guards={"isUint16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doUint16ArrayObj(DynamicObject target, int index, int value) {
            return this.atomicDoInt(target, index, value) & 0xFFFF;
        }

        @Specialization(guards={"isInt32SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt32ArrayObj(DynamicObject target, int index, int value) {
            return this.atomicDoInt(target, index, value);
        }

        @Specialization(guards={"isUint32SharedBufferView(target)", "inboundFast(target,index)"})
        protected SafeInteger doUint32ArrayObj(DynamicObject target, int index, int value) {
            return SafeInteger.valueOf((long)this.atomicDoInt(target, index, value) & 0xFFFFFFFFL);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)"})
        protected int doInt32ArrayObjObjIdx(DynamicObject target, Object index, int value, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsComputeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.atomicDoInt(target, intIndex, value);
        }

        @Specialization(guards={"isBigInt64SharedBufferView(target) || isBigUint64SharedBufferView(target)"})
        protected BigInt doBigInt64ArrayObjObjIdx(DynamicObject target, Object index, Object value, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsComputeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.atomicDoBigInt(target, intIndex, this.toBigInt(value));
        }

        @Specialization
        protected Object doGeneric(Object maybeTarget, Object index, Object value, @Cached(value="create()") JSToIndexNode toIndexNode) {
            DynamicObject target = this.ensureDynamicObject(maybeTarget);
            TypedArray ta = this.validateSharedIntegerTypedArray(target, false);
            int intIndex = AtomicsComputeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            if (ta instanceof TypedArray.DirectInt8Array) {
                return (int)((byte)this.atomicDoInt(target, intIndex, this.toInt(value)));
            }
            if (ta instanceof TypedArray.DirectUint8Array) {
                return (byte)this.atomicDoInt(target, intIndex, this.toInt(value)) & 0xFF;
            }
            if (ta instanceof TypedArray.DirectInt16Array) {
                return this.atomicDoInt(target, intIndex, this.toInt(value));
            }
            if (ta instanceof TypedArray.DirectUint16Array) {
                return this.atomicDoInt(target, intIndex, this.toInt(value)) & 0xFFFF;
            }
            if (ta instanceof TypedArray.DirectInt32Array) {
                return this.atomicDoInt(target, intIndex, this.toInt(value));
            }
            if (ta instanceof TypedArray.DirectUint32Array) {
                return SafeInteger.valueOf((long)this.atomicDoInt(target, intIndex, this.toInt(value)) & 0xFFFFFFFFL);
            }
            if (ta instanceof TypedArray.DirectBigInt64Array || ta instanceof TypedArray.DirectBigUint64Array) {
                return this.atomicDoBigInt(target, intIndex, this.toBigInt(value));
            }
            throw Errors.shouldNotReachHere();
        }

        private int toInt(Object v) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = (JSToIntegerAsLongNode)this.insert(JSToIntegerAsLongNode.create());
            }
            return (int)this.toIntNode.executeLong(v);
        }

        private BigInt toBigInt(Object v) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = (JSToBigIntNode)this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.executeBigInteger(v);
        }
    }

    public static abstract class AtomicsStoreNode
    extends AtomicsOperationNode {
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        @Node.Child
        private JSToIntegerAsLongNode toIntNode;

        public AtomicsStoreNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isInt8SharedBufferView(target)||isUint8SharedBufferView(target)", "inboundFast(target,index)"})
        protected Object doIntArrayObj(DynamicObject target, int index, int value) {
            SharedMemorySync.doVolatilePut(target, index, value);
            return value;
        }

        @Specialization(guards={"isInt8SharedBufferView(target)||isUint8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doIntArrayObj(DynamicObject target, int index, double value) {
            int v = (int)this.toInt(value);
            SharedMemorySync.doVolatilePut(target, index, v);
            return v;
        }

        @Specialization(guards={"isInt16SharedBufferView(target)||isUint16SharedBufferView(target)", "inboundFast(target,index)"})
        protected Object doInt16ArrayObj(DynamicObject target, int index, int value) {
            SharedMemorySync.doVolatilePut(target, index, (short)value);
            return value;
        }

        @Specialization(guards={"isInt16SharedBufferView(target)||isUint16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt16ArrayObj(DynamicObject target, int index, double value) {
            int v = (int)this.toInt(value);
            SharedMemorySync.doVolatilePut(target, index, v);
            return v;
        }

        @Specialization(guards={"isInt32SharedBufferView(target)||isUint32SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt32ArrayObj(DynamicObject target, int index, int value) {
            SharedMemorySync.doVolatilePut(target, index, value);
            return value;
        }

        @Specialization(guards={"isInt32SharedBufferView(target)||isUint32SharedBufferView(target)", "inboundFast(target,index)"})
        protected Object doInt32ArrayObj(DynamicObject target, int index, double value) {
            long v = this.toInt(value);
            SharedMemorySync.doVolatilePut(target, index, (int)v);
            return SafeInteger.valueOf(v);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)"})
        protected Object doInt32ArrayObjObjIdx(DynamicObject target, Object index, int value, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsStoreNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            SharedMemorySync.doVolatilePut(target, intIndex, value);
            return value;
        }

        @Specialization(guards={"isBigInt64SharedBufferView(target) || isBigUint64SharedBufferView(target)"})
        protected Object doBigInt64ArrayObjObjIdx(DynamicObject target, Object index, Object value, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsStoreNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            BigInt biValue = this.toBigInt(value);
            SharedMemorySync.doVolatilePutBigInt(target, intIndex, biValue);
            return biValue;
        }

        @Specialization
        protected Object doGeneric(Object maybeTarget, Object index, Object value, @Cached(value="create()") JSToIndexNode toIndexNode) {
            DynamicObject target = this.ensureDynamicObject(maybeTarget);
            TypedArray ta = this.validateSharedIntegerTypedArray(target, false);
            int intIndex = AtomicsStoreNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            if (ta instanceof TypedArray.DirectInt8Array || ta instanceof TypedArray.DirectUint8Array) {
                int v = (int)this.toInt(value);
                SharedMemorySync.doVolatilePut(target, intIndex, v);
                return v;
            }
            if (ta instanceof TypedArray.DirectInt16Array || ta instanceof TypedArray.DirectUint16Array) {
                int v = (int)this.toInt(value);
                SharedMemorySync.doVolatilePut(target, intIndex, (short)v);
                return v;
            }
            if (ta instanceof TypedArray.DirectInt32Array || ta instanceof TypedArray.DirectUint32Array) {
                long v = this.toInt(value);
                SharedMemorySync.doVolatilePut(target, intIndex, (int)v);
                return SafeInteger.valueOf(v);
            }
            if (ta instanceof TypedArray.DirectBigInt64Array || ta instanceof TypedArray.DirectBigUint64Array) {
                BigInt v = this.toBigInt(value);
                SharedMemorySync.doVolatilePutBigInt(target, intIndex, v);
                return v;
            }
            throw Errors.shouldNotReachHere();
        }

        private long toInt(Object v) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = (JSToIntegerAsLongNode)this.insert(JSToIntegerAsLongNode.create());
            }
            return this.toIntNode.executeLong(v);
        }

        private BigInt toBigInt(Object v) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = (JSToBigIntNode)this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.executeBigInteger(v);
        }
    }

    public static abstract class AtomicsLoadNode
    extends AtomicsOperationNode {
        public AtomicsLoadNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public abstract Object executeWithBufferAndIndex(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"isInt8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt8ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGet(target, index);
        }

        @Specialization(guards={"isUint8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doUint8ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGet(target, index) & 0xFF;
        }

        @Specialization(guards={"isInt16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt16ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGet(target, index);
        }

        @Specialization(guards={"isUint16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doUint16ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGet(target, index) & 0xFFFF;
        }

        @Specialization(guards={"isInt32SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt32ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGet(target, index);
        }

        @Specialization(guards={"isUint32SharedBufferView(target)", "inboundFast(target,index)"})
        protected SafeInteger doUint32ArrayObj(DynamicObject target, int index) {
            return SafeInteger.valueOf((long)SharedMemorySync.doVolatileGet(target, index) & 0xFFFFFFFFL);
        }

        @Specialization(guards={"isBigInt64SharedBufferView(target)", "inboundFast(target,index)"})
        protected BigInt doBigInt64ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGetBigInt(target, index);
        }

        @Specialization(guards={"isBigUint64SharedBufferView(target)", "inboundFast(target,index)"})
        protected BigInt doBigUint64ArrayObj(DynamicObject target, int index) {
            return SharedMemorySync.doVolatileGetBigInt(target, index);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)"})
        protected int doInt32ArrayObjObjIdx(DynamicObject target, Object index, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsLoadNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return SharedMemorySync.doVolatileGet(target, intIndex);
        }

        @Specialization
        protected Object doGeneric(Object maybeTarget, Object index, @Cached(value="create()") JSToIndexNode toIndexNode) {
            DynamicObject target = this.ensureDynamicObject(maybeTarget);
            TypedArray ta = this.validateSharedIntegerTypedArray(target, false);
            int intIndex = AtomicsLoadNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            if (ta instanceof TypedArray.DirectInt8Array) {
                return SharedMemorySync.doVolatileGet(target, intIndex);
            }
            if (ta instanceof TypedArray.DirectUint8Array) {
                return SharedMemorySync.doVolatileGet(target, intIndex) & 0xFF;
            }
            if (ta instanceof TypedArray.DirectInt16Array) {
                return SharedMemorySync.doVolatileGet(target, intIndex);
            }
            if (ta instanceof TypedArray.DirectUint16Array) {
                return SharedMemorySync.doVolatileGet(target, intIndex) & 0xFFFF;
            }
            if (ta instanceof TypedArray.DirectInt32Array) {
                return SharedMemorySync.doVolatileGet(target, intIndex);
            }
            if (ta instanceof TypedArray.DirectUint32Array) {
                return SafeInteger.valueOf((long)SharedMemorySync.doVolatileGet(target, intIndex) & 0xFFFFFFFFL);
            }
            if (ta instanceof TypedArray.DirectBigInt64Array) {
                return SharedMemorySync.doVolatileGetBigInt(target, intIndex);
            }
            if (ta instanceof TypedArray.DirectBigUint64Array) {
                return SharedMemorySync.doVolatileGetBigInt(target, intIndex);
            }
            throw Errors.shouldNotReachHere();
        }
    }

    public static abstract class AtomicsCompareExchangeNode
    extends AtomicsOperationNode {
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        @Node.Child
        private JSToIntegerAsLongNode toIntNode;

        public AtomicsCompareExchangeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected int doCASInt8(DynamicObject target, int index, int expected, int replacement, boolean sign) {
            return SharedMemorySync.atomicFetchOrGetByte(this.getContext(), target, index, (byte)expected, replacement, sign);
        }

        protected int doCASInt16(DynamicObject target, int index, int expected, int replacement, boolean sign) {
            return SharedMemorySync.atomicFetchOrGetShort(this.getContext(), target, index, expected, replacement, sign);
        }

        protected Object doCASUint32(DynamicObject target, int index, Object expected, Object replacement) {
            return SafeInteger.valueOf(SharedMemorySync.atomicFetchOrGetUnsigned(this.getContext(), target, index, expected, replacement));
        }

        protected int doCASInt(DynamicObject target, int index, int expected, int replacement) {
            return SharedMemorySync.atomicFetchOrGetInt(this.getContext(), target, index, expected, replacement);
        }

        protected BigInt doCASBigInt(DynamicObject target, int index, BigInt expected, BigInt replacement) {
            return SharedMemorySync.atomicFetchOrGetBigInt(this.getContext(), target, index, expected, replacement);
        }

        @Specialization(guards={"isInt8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt8ArrayByte(DynamicObject target, int index, int expected, int replacement) {
            return this.doCASInt8(target, index, expected, replacement, true);
        }

        @Specialization(guards={"isUint8SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doUint8ArrayByte(DynamicObject target, int index, int expected, int replacement) {
            return this.doCASInt8(target, index, expected, replacement, false);
        }

        @Specialization(guards={"isInt16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt16ArrayByte(DynamicObject target, int index, int expected, int replacement) {
            return this.doCASInt16(target, index, expected, replacement, true);
        }

        @Specialization(guards={"isUint16SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doUint16ArrayByte(DynamicObject target, int index, int expected, int replacement) {
            return this.doCASInt16(target, index, expected, replacement, false);
        }

        @Specialization(guards={"isUint32SharedBufferView(target)", "inboundFast(target,index)"})
        protected Object doUint32ArrayByte(DynamicObject target, int index, Object expected, Object replacement) {
            return this.doCASUint32(target, index, expected, replacement);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt32ArrayByte(DynamicObject target, int index, byte expected, byte replacement) {
            return this.doCASInt(target, index, expected, replacement);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt32ArrayInt(DynamicObject target, int index, int expected, int replacement) {
            return this.doCASInt(target, index, expected, replacement);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)", "inboundFast(target,index)"})
        protected int doInt32ArrayObj(DynamicObject target, int index, Object expected, Object replacement) {
            return this.doCASInt(target, index, this.toInt(expected), this.toInt(replacement));
        }

        @Specialization(guards={"isInt32SharedBufferView(target)"})
        protected int doInt32ArrayByteObjIdx(DynamicObject target, Object index, byte expected, byte replacement, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsCompareExchangeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.doCASInt(target, intIndex, expected, replacement);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)"})
        protected int doInt32ArrayIntObjIdx(DynamicObject target, Object index, int expected, int replacement, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsCompareExchangeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.doCASInt(target, intIndex, expected, replacement);
        }

        @Specialization(guards={"isInt32SharedBufferView(target)"})
        protected int doInt32ArrayObjObjIdx(DynamicObject target, Object index, Object expected, Object replacement, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsCompareExchangeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.doCASInt(target, intIndex, this.toInt(expected), this.toInt(replacement));
        }

        @Specialization(guards={"isBigInt64SharedBufferView(target)"})
        protected BigInt doBigInt64ArrayObjObjIdx(DynamicObject target, Object index, Object expected, Object replacement, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsCompareExchangeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.doCASBigInt(target, intIndex, this.toBigInt(expected).toBigInt64(), this.toBigInt(replacement));
        }

        @Specialization(guards={"isBigUint64SharedBufferView(target)"})
        protected BigInt doBigUint64ArrayObjObjIdx(DynamicObject target, Object index, Object expected, Object replacement, @Cached(value="create()") JSToIndexNode toIndexNode) {
            int intIndex = AtomicsCompareExchangeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            return this.doCASBigInt(target, intIndex, this.toBigInt(expected).toBigUint64(), this.toBigInt(replacement));
        }

        @Specialization
        protected Object doGeneric(Object maybeTarget, Object index, Object expected, Object replacement, @Cached(value="create()") JSToIndexNode toIndexNode) {
            DynamicObject target = this.ensureDynamicObject(maybeTarget);
            TypedArray ta = this.validateSharedIntegerTypedArray(target, false);
            int intIndex = AtomicsCompareExchangeNode.validateAtomicAccess(target, toIndexNode.executeLong(index), index);
            if (ta instanceof TypedArray.DirectInt8Array) {
                return this.doCASInt8(target, intIndex, this.toInt(expected), this.toInt(replacement), true);
            }
            if (ta instanceof TypedArray.DirectUint8Array) {
                return this.doCASInt8(target, intIndex, this.toInt(expected), this.toInt(replacement), false);
            }
            if (ta instanceof TypedArray.DirectInt16Array) {
                return this.doCASInt16(target, intIndex, this.toInt(expected), this.toInt(replacement), true);
            }
            if (ta instanceof TypedArray.DirectUint16Array) {
                return this.doCASInt16(target, intIndex, this.toInt(expected), this.toInt(replacement), false);
            }
            if (ta instanceof TypedArray.DirectInt32Array) {
                return this.doCASInt(target, intIndex, this.toInt(expected), this.toInt(replacement));
            }
            if (ta instanceof TypedArray.DirectUint32Array) {
                return this.doCASUint32(target, intIndex, this.toInt(expected), this.toInt(replacement));
            }
            if (ta instanceof TypedArray.DirectBigInt64Array) {
                return this.doCASBigInt(target, intIndex, this.toBigInt(expected).toBigInt64(), this.toBigInt(replacement));
            }
            if (ta instanceof TypedArray.DirectBigUint64Array) {
                return this.doCASBigInt(target, intIndex, this.toBigInt(expected).toBigUint64(), this.toBigInt(replacement));
            }
            throw Errors.shouldNotReachHere();
        }

        private int toInt(Object v) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = (JSToIntegerAsLongNode)this.insert(JSToIntegerAsLongNode.create());
            }
            return (int)this.toIntNode.executeLong(v);
        }

        private BigInt toBigInt(Object v) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = (JSToBigIntNode)this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.executeBigInteger(v);
        }
    }

    public static abstract class AtomicsOperationNode
    extends JSBuiltinNode {
        public AtomicsOperationNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public static boolean isSharedBufferView(Object object) {
            return JSDynamicObject.isJSDynamicObject(object) && AtomicsOperationNode.isSharedBufferView((DynamicObject)object);
        }

        public static boolean isSharedBufferView(DynamicObject object) {
            return JSArrayBufferView.isJSArrayBufferView(object) && JSSharedArrayBuffer.isJSSharedArrayBuffer(JSArrayBufferView.getArrayBuffer(object));
        }

        public static boolean isInt8SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectInt8Array;
        }

        public static boolean isUint8SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectUint8Array;
        }

        public static boolean isInt16SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectInt16Array;
        }

        public static boolean isUint16SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectUint16Array;
        }

        public static boolean isInt32SharedBufferView(Object object) {
            return JSDynamicObject.isJSDynamicObject(object) && AtomicsOperationNode.isInt32SharedBufferView((DynamicObject)object);
        }

        public static boolean isInt32SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectInt32Array;
        }

        public static boolean isUint32SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectUint32Array;
        }

        public static boolean isBigInt64SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectBigInt64Array;
        }

        public static boolean isBigUint64SharedBufferView(DynamicObject object) {
            return AtomicsOperationNode.isSharedBufferView(object) && JSArrayBufferView.typedArrayGetArrayType(object) instanceof TypedArray.DirectBigUint64Array;
        }

        public static boolean isBigInt64SharedBufferView(Object object) {
            return JSDynamicObject.isJSDynamicObject(object) && AtomicsOperationNode.isBigInt64SharedBufferView((DynamicObject)object);
        }

        protected static int validateAtomicAccess(DynamicObject target, long convertedIndex, Object originalIndex) {
            int length = JSArrayBufferView.typedArrayGetLength(target);
            assert (convertedIndex >= 0L);
            if (convertedIndex >= (long)length) {
                throw AtomicsOperationNode.createRangeErrorSharedArray(originalIndex);
            }
            return (int)convertedIndex;
        }

        protected TypedArray validateSharedIntegerTypedArray(DynamicObject object, boolean waitable) {
            if (!AtomicsOperationNode.isSharedBufferView(object)) {
                throw this.createTypeErrorNotSharedArray();
            }
            TypedArray ta = JSArrayBufferView.typedArrayGetArrayType(object);
            if (waitable) {
                if (!(ta instanceof TypedArray.DirectInt32Array) && !(ta instanceof TypedArray.DirectBigInt64Array)) {
                    throw this.createTypeErrorNotWaitableSharedIntArray();
                }
            } else if (!(ta instanceof TypedArray.DirectInt8Array || ta instanceof TypedArray.DirectUint8Array || ta instanceof TypedArray.DirectInt16Array || ta instanceof TypedArray.DirectUint16Array || ta instanceof TypedArray.DirectInt32Array || ta instanceof TypedArray.DirectUint32Array || ta instanceof TypedArray.DirectBigInt64Array || ta instanceof TypedArray.DirectBigUint64Array)) {
                throw this.createTypeErrorNotSharedIntArray();
            }
            return ta;
        }

        protected DynamicObject ensureDynamicObject(Object maybeTarget) {
            if (!(maybeTarget instanceof DynamicObject)) {
                throw this.createTypeErrorNotSharedArray();
            }
            return (DynamicObject)maybeTarget;
        }

        protected static boolean inboundFast(DynamicObject target, int index) {
            TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
            return array.isInBoundsFast(target, index);
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSException createTypeErrorNotSharedArray() {
            return Errors.createTypeError("Cannot execute on non-shared array.", (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSException createTypeErrorNotSharedIntArray() {
            return Errors.createTypeError("Can only execute on selected types of shared int typed arrays (\"Int8Array\", \"Uint8Array\", \"Int16Array\", \"Uint16Array\",  \"Int32Array\", \"Uint32Array\", \"BigUint64Array\", or \"BigInt64Array\").", (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSException createTypeErrorNotWaitableSharedIntArray() {
            return Errors.createTypeError("Can only execute on shared Int32Array or BigInt64Array typed arrays.", (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        protected static final JSException createRangeErrorSharedArray(Object idx) {
            return Errors.createRangeError("Range error with index : " + idx);
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSException createTypeErrorUnsupported() {
            return Errors.createTypeError("Unsupported operation", (Node)this);
        }
    }

    public static final class AtomicsWaitAsyncBuiltin
    extends JSBuiltinsContainer.SwitchEnum<AtomicsWaitAsync> {
        protected AtomicsWaitAsyncBuiltin() {
            super("Atomics", AtomicsWaitAsync.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, AtomicsWaitAsync builtinEnum) {
            switch (builtinEnum) {
                case waitAsync: {
                    return AtomicsBuiltinsFactory.AtomicsWaitAsyncNodeGen.create(context, builtin, AtomicsWaitAsyncBuiltin.args().fixedArgs(4).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum AtomicsWaitAsync implements BuiltinEnum<AtomicsWaitAsync>
        {
            waitAsync(4);

            private final int length;

            private AtomicsWaitAsync(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static enum Atomics implements BuiltinEnum<Atomics>
    {
        compareExchange(4),
        load(2),
        store(3),
        add(3),
        sub(3),
        and(3),
        or(3),
        xor(3),
        exchange(3),
        wake(3),
        wait(4),
        isLockFree(1),
        notify(3);

        private final int length;

        private Atomics(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (this.equals(notify)) {
                return 10;
            }
            return 8;
        }
    }
}

